### R code from vignette source 'VSS_JSAL2010.Rnw'

###################################################
### code chunk number 1: VSS_JSAL2010.Rnw:351-514
###################################################

map <- function(vec, from, to) {
       newVec <- vec
       for( i in 1:length(from) ) {
               newVec[vec == from[i]] <- to[i]
       }
       return(newVec)
}

################################################################
## Start Preliminaries ###########################################
################################################################



## Load data:
## standard RT data:
d <- read.table("data/sfb1e1.dat", header=T)
#check:
#table(d$subject,d$item)

## conditional regression information:
#     CFC: (Conditional Fixation Count) Number of fixations on roi after
#          sourceRoi has been fixated, but before any region right of
#          sourceRoi has been fixated. Two subsequent fixations on one
#          region (i.e. when no other region is looked at inbetween) are
#          considered one fixation.
#     CFT: (Conditional Fixation Time) Amount of time spent on fixating
#          roi under the conditions described for CFC. 
dcri <- read.table("data/sfb1e1cri.dat", header=T)

## this function adds the condition columns:
addConditions <- function(d)
{
  d$wo <- map(as.integer(d$condition),
              1:16,c(rep('can',8),rep('ncan',8))) 
  d$wo <- factor(d$wo)
  ##
  d$foc <-map(as.integer(d$condition),
              1:16, rep(c('nfoc','foc'),8))
  d$foc <- factor(d$foc)
  ##
  d$giv <- map(as.integer(d$condition),
               1:16, c(rep(c("givnew","newgiv"),each=2,2),
                       rep(c("newgiv","givnew"),each=2,2)))
  d$giv <- factor(d$giv)
  ##
  d$rel <-map(as.integer(d$condition),
              1:16,rep(c("relnew","relgiv"),each=2,4))
  d$rel <- factor(d$rel)
  ##
  d$ant <- map(as.integer(d$condition),
               1:16, rep(c("objant","subjant"),each=4,2))
  d$ant <- factor(d$ant)
  return(d)
}


d <- addConditions(d)
dcri <- addConditions(dcri)

## name the regions: NP1, NP2 and integration region
d$region <- ifelse(d$roi==6,"NP1",
                   ifelse((d$wo=='can' & d$foc=='nfoc' & d$roi==9) |
                          (d$wo=='can' & d$foc=='foc' & d$roi==10) |
                          (d$wo=='ncan' & d$foc=='nfoc' & d$roi==8) |
                          (d$wo=='ncan' & d$foc=='foc' & d$roi==8),"int",
                          ifelse((d$wo=='can' & d$foc=='nfoc' & d$roi==7) |
                                 (d$wo=='can' & d$foc=='foc' & d$roi==8) |    
                                 (d$wo=='ncan' & d$foc=='nfoc' & d$roi==9) | 
                                 (d$wo=='ncan' & d$foc=='foc' & d$roi==9),
                                 "NP2","other"))) 
d$region <- factor(d$region)
## Mark the first NP as given or new
n1status <- ifelse((d$wo=="can" & d$giv=="givnew"),"giv",
                   ifelse((d$wo=="can" & d$giv=="newgiv"),"new",
                          ifelse((d$wo=="ncan" & d$giv=="givnew"),"giv",
                                 ifelse((d$wo=="ncan" & d$giv=="newgiv"),"new","none"))))
d$n1status <- factor(n1status)

dcri$region <- ifelse(dcri$srcRoi==6,"NP1",
                   ifelse((dcri$wo=='can' & dcri$foc=='nfoc' & dcri$srcRoi==9) |
                          (dcri$wo=='can' & dcri$foc=='foc' & dcri$srcRoi==10) |
                          (dcri$wo=='ncan' & dcri$foc=='nfoc' & dcri$srcRoi==8) |
                          (dcri$wo=='ncan' & dcri$foc=='foc' & dcri$srcRoi==8),"int",
                          ifelse((dcri$wo=='can' & dcri$foc=='nfoc' & dcri$srcRoi==7) |
                                 (dcri$wo=='can' & dcri$foc=='foc' & dcri$srcRoi==8) |    
                                 (dcri$wo=='ncan' & dcri$foc=='nfoc' & dcri$srcRoi==9) | 
                                 (dcri$wo=='ncan' & dcri$foc=='foc' & dcri$srcRoi==9),
                                 "NP2","other"))) 
dcri$region <- factor(dcri$region)
## is the first NP given or new
n1status <- ifelse((dcri$wo=="can" & dcri$giv=="givnew"),"giv",
                   ifelse((dcri$wo=="can" & dcri$giv=="newgiv"),"new",
                          ifelse((dcri$wo=="ncan" & dcri$giv=="givnew"),"giv",
                                 ifelse((dcri$wo=="ncan" & dcri$giv=="newgiv"),"new","none"))))
dcri$n1status <- factor(n1status)

## orthogonal contrasts:
#     c.nf.g c.nf.n c.f.g c.f.n nc.nf.g nc.nf.n nc.f.g nc.f.n 
#wd      -1     -1    -1    -1      1        1      1      1
#fc      -1     -1     1     1     -1       -1      1      1
#n1      -1      1    -1     1     -1        1     -1      1
#fc.n1   -1      1     1    -1     -1        1      1     -1 
#wo.n1   -1      1    -1     1      1       -1      1     -1 
#fc.wo   -1     -1     1     1      1        1     -1     -1

## set up orthogonal contrasts
wd <- ifelse(d$wo=="can",-1,ifelse(d$wo=="ncan",1,0))
fc <- ifelse(d$foc=="nfoc",-1,ifelse(d$foc=="foc",1,0)) 
n1giv <- ifelse(d$n1status=="giv",-1,ifelse(d$n1status=="new",1,0)) 
fc.n1giv <- ifelse(((d$foc=="nfoc" & d$n1status=="giv")|
                (d$foc=="foc" & d$n1status=="new")),-1,
                ifelse(((d$foc=="nfoc" & d$n1status=="new")|
                (d$foc=="foc" & d$n1status=="giv")),1,0))
wo.n1giv <- ifelse(((d$wo=="can" & d$n1status=="giv")|
                (d$wo=="ncan" & d$n1status=="new")),-1,
                ifelse(((d$wo=="can" & d$n1status=="new")|
                (d$wo=="ncan" & d$n1status=="giv")),1,0))
fc.wo <- ifelse(((d$foc=="nfoc" & d$wo=="can")|
                (d$foc=="foc" & d$wo=="ncan")),-1,
                ifelse(((d$foc=="nfoc" & d$wo=="ncan")|
                (d$foc=="foc" & d$wo=="can")),1,0))

d$wd <- wd
d$fc <- fc
d$n1giv <- n1giv
d$fc.n1giv <- fc.n1giv
d$wo.n1giv <- wo.n1giv
d$fc.wo <- fc.wo
d$n2giv <- ifelse(d$n1giv==1,-1,ifelse(d$n1giv==-1,1,0))
d$n2status <- ifelse(d$n1status=="new","giv",ifelse(d$n1status=="giv","new","NA"))


wd <- ifelse(dcri$wo=="can",-1,ifelse(dcri$wo=="ncan",1,0))
fc <- ifelse(dcri$foc=="nfoc",-1,ifelse(dcri$foc=="foc",1,0)) 
n1giv <- ifelse(dcri$n1status=="giv",-1,ifelse(dcri$n1status=="new",1,0)) 
fc.n1giv <- ifelse(((dcri$foc=="nfoc" & dcri$n1status=="giv")|
                (dcri$foc=="foc" & dcri$n1status=="new")),-1,
                ifelse(((dcri$foc=="nfoc" & dcri$n1status=="new")|
                (dcri$foc=="foc" & dcri$n1status=="giv")),1,0))
wo.n1giv <- ifelse(((dcri$wo=="can" & dcri$n1status=="giv")|
                (dcri$wo=="ncan" & dcri$n1status=="new")),-1,
                ifelse(((dcri$wo=="can" & dcri$n1status=="new")|
                (dcri$foc=="ncan" & dcri$n1status=="giv")),1,0))
fc.wo <- ifelse(((dcri$foc=="nfoc" & dcri$wo=="can")|
                (dcri$foc=="foc" & dcri$wo=="ncan")),-1,
                ifelse(((dcri$foc=="nfoc" & dcri$wo=="ncan")|
                (dcri$foc=="foc" & dcri$wo=="can")),1,0))

dcri$wd <- wd
dcri$fc <- fc
dcri$n1giv <- n1giv
dcri$fc.n1giv <- fc.n1giv
dcri$wo.n1giv <- wo.n1giv
dcri$fc.wo <- fc.wo
dcri$n2giv <- ifelse(dcri$n1giv==1,-1,ifelse(dcri$n1giv==-1,1,0))
dcri$n2status <- ifelse(dcri$n1status=="new","giv",ifelse(dcri$n1status=="giv","new","NA"))

################################################################
## End Preliminaries ###########################################
################################################################



###################################################
### code chunk number 2: VSS_JSAL2010.Rnw:867-908
###################################################
library(lme4)
library(car)

options(digits=3)

## first-pass regression probability:
fp_reg <- ifelse(d$RBRC>0,1,0) 
d$fp_reg <- fp_reg

## Note from 23 Aug 2010 (SV):
## checked that this coding gives the same results as separate paired t-tests on the various contrasts.
## The paired t-tests (on aggregated proportions by subj) actually show stronger effects, which suggests that lmer
## is giving more conservative t-values. 

## Note: wd rather than wo gives a false convergence, but it doesn't seem
## like it matters:
fp_reg.m <- lmer(fp_reg~wd+fc+n1giv+fc.n1giv+wo.n1giv+fc.wo+
                         (1|subject)+(1|item),family=binomial(),
                          subset(d,(region=="NP1")))

## how to extract the results of the analysis:
Vcov <- vcov(fp_reg.m, useScale = FALSE)
betas <- fixef(fp_reg.m)
se <- sqrt(diag(Vcov))
zval <- betas / se
pval <- 2 * pnorm(abs(zval), lower.tail = FALSE)
		
pval.crits<-ifelse(pval<0.01,"0.01",ifelse(pval<0.05,"0.05","ns"))
						
means.fpreg.foc<- with(subset(d,(region=="NP1")),tapply(fp_reg,
                 IND=list(foc),
                 mean))*100

means.fpreg.foc.giv<-with(subset(d,(region=="NP1")),tapply(fp_reg,
                 IND=list(foc,giv),
                 mean))*100

means.fpreg.foc.wo<-with(subset(d,(region=="NP1")),tapply(fp_reg,
                 IND=list(foc,wo),
                 mean))*100



###################################################
### code chunk number 3: VSS_JSAL2010.Rnw:911-929
###################################################

## check statistically if lekin vs aur is the source of the increased regression probability at the NP1.
## if this were true, then there would be a correlation between the proportion of regressions from lekin vs aur, and the 
## proportion of regressions between the clefted vs non-clefted case. However, we find that the proportion of regressions
## in the lekin/aur region do not predict proportion of regressions at NP1. This is a null result and therefore not possible to 
## draw conclusions from, but it is at least suggestive that the difficulty in the cleft is not due to the presence of lekin.

lekinaur<-subset(d,(roi==5))

d.np1<-subset(d,(region=="NP1"))

d.np1$fp_reg.lekin<-lekinaur$fp_reg

fp_reg.m2 <- lmer(fp_reg~wo+fc+n1giv+fc.n1giv+wo.n1giv+fc.wo+fp_reg.lekin+fc:fp_reg.lekin+
                         (1|subject)+(1|item),family=binomial(),
                          d.np1)




###################################################
### code chunk number 4: VSS_JSAL2010.Rnw:977-982
###################################################

m0.rrt0 <- lmer(log(RRT/1000+1)~wd+fc+n1giv+fc.n1giv+wo.n1giv+fc.wo+
                   (1|subject)+(1|item),
             subset(d,region=="NP1"))



###################################################
### code chunk number 5: VSS_JSAL2010.Rnw:1065-1076
###################################################
means.cri.intNP1.foc <- with(subset(dcri,(region=="int" & dstRoi==6)),
   (tapply(as.logical(CFT),foc,mean)))

means.cri.intNP1.wo <- with(subset(dcri,(region=="int" & dstRoi==6)),
   (tapply(as.logical(CFT),wo,mean)))

## proportion of regressions from int to NP1              
fm.cri.intNP1 <-lmer(as.logical(CFT)~fc+wd+n1giv+fc.wo+fc.n1giv+wo.n1giv+
     (1|subject)+(1|item),family=binomial(),
             subset(dcri,(region=="int" & dstRoi==6)))



###################################################
### code chunk number 6: VSS_JSAL2010.Rnw:1084-1092
###################################################

means.int.wo<-with(subset(d,(RRT & region=="int")),tapply(RRT,wo,mean))/1000
means.int.foc<-with(subset(d,(RRT & region=="int")),tapply(RRT,foc,mean))/1000
means.int.n1<-with(subset(d,(RRT & region=="int")),tapply(RRT,n1status,mean))/1000
means.int.focn1<-with(subset(d,(RRT & region=="int")),tapply(RRT,IND=list(foc,n1status),mean))/1000
means.int.won1<-with(subset(d,(RRT & region=="int")),tapply(RRT,IND=list(wo,n1status),mean))/1000
means.int.wofoc<-with(subset(d,(RRT & region=="int")),tapply(RRT,IND=list(wo,foc),mean))/1000



###################################################
### code chunk number 7: VSS_JSAL2010.Rnw:1118-1123
###################################################

m <- lmer(log(RRT/1000+1)~wd+fc+n1giv+fc.n1giv+wo.n1giv+fc.wo+
                   (1|subject)+(1|item),
             subset(d,region=="int"))



###################################################
### code chunk number 8: VSS_JSAL2010.Rnw:1285-1331
###################################################

data<-read.table("data/sfb1e2.dat",header=T)

droppedrows<-ifelse(data$FFD==0 & data$FPRT==0 & data$SFD==0 & data$FPRT==0 & 
    data$RBRT==0 &data$TFT==0 & data$RRT==0 & data$RPD==0,"drop","keep")

data$droppedrows<-droppedrows
data<-subset(data,droppedrows=="keep")

#condition  cleft wo   ant
##a          no    can  subj
##b          yes   can  subj
##c          no    ncan subj
##d          yes   ncan subj 
##e          no    can  obj
##f          yes   can  obj
##g          no    ncan obj 
##h          yes   ncan obj

cleft<-ifelse(data$condition%in%c("a","c","e","g"),-1,1)
wo<-ifelse(data$condition%in%c("a","b","e","f"),-1,1)
ant<-ifelse(data$condition%in%c("a","b","c","d"),1,-1)

# subj ant. and SOV vs OSV
# obj ant. and  OSV vs  SOV
 
 data$cleft<-cleft
 data$wo<-wo
 data$ant<-ant
 
 # for plots
 cleft2<-ifelse(data$condition%in%c("a","c","e","g"),"non.cleft","cleft")
 wo2<-ifelse(data$condition%in%c("a","b","e","f"),"can","non.can")
 ant2<-ifelse(data$condition%in%c("a","b","c","d"),"subj","obj")
 
data$cleft2<-factor(cleft2,levels=c("non.cleft","cleft"))
 data$wo2<-factor(wo2,levels=c("can","non.can"))
 data$ant2<-factor(ant2,levels=c("subj","obj"))


 data_1<-subset(data,subtrial==1)
 data_2<-subset(data,subtrial==2)
 data_3<-subset(data,subtrial==3)
 
### end preliminaries



###################################################
### code chunk number 9: VSS_JSAL2010.Rnw:1338-1360
###################################################

## Reading times:
 
 ## the clefted or non-clefted word:

 data_2_roi1<-subset(data_2,roi==1) ## NP1 
 data_2_roi3<-subset(data_2,roi==3) ## retrieval region
 
 data_3_roi1<-subset(data_3,roi==1) # vo
 data_3_roi3<-subset(data_3,roi==3) # disambiguation region
 
fm3a <- lmer(log(RRT)~cleft*wo+(1+cleft|subject)+(1|item),
     subset(data_2_roi1,RRT> 0 & RRT<2000))

meansroi1Cl<-with(subset(data_2_roi1,RRT> 0 & RRT<2000),tapply(RRT,IND=list(cleft2),mean,na.rm=TRUE))

rrp<-ifelse(data_2_roi1$RRT==0,0,1)
data_2_roi1$rrp<-rrp

## no effect in re-reading probability:
fm3a3 <- lmer(rrp~cleft*wo+(1|subject)+(1|item),family=binomial(),data_2_roi1)



###################################################
### code chunk number 10: VSS_JSAL2010.Rnw:1397-1404
###################################################

## advantage due to clefting in the retrieval region
fm.ffd<-lmer(log(FFD)~cleft*wo+(1|subject)+(1|item),
     subset(data_2_roi3,FFD>0 & FFD<2000))

means.cleft.wo<- round(with(subset(data_2_roi3,FFD>0 & FFD<2000),tapply(FFD,IND=list(cleft2,wo2),mean,na.rm=T)))



###################################################
### code chunk number 11: VSS_JSAL2010.Rnw:1427-1431
###################################################

means.int.cleftant<-with(subset(data_3_roi3,RRT>0 & RRT<2000 & wo2=="can"),
tapply(RRT,IND=list(cleft2,ant2),mean))



###################################################
### code chunk number 12: VSS_JSAL2010.Rnw:1444-1456
###################################################

## effect of antecedent significant only if one excludes 0's:
fm1.rrt2<-lmer(log(RRT)~cleft*ant+
                (1|subject)+(1|item),
                                subset(data_3_roi3,RRT>0 & RRT<2000 & wo2=="can"))

## effect of clefting in re-reading probability:
rrp<-ifelse(data_3_roi3$RRT==0,0,1)
data_3_roi3$rrp<-rrp

fm1.rrp3<-lmer(rrp~cleft*ant+(1|subject)+(1|item),family=binomial(),data_3_roi3)



