## <<plot-HPD-intervals-setup>>=
## ## read HPD interval tables and support code
source("hpd-plotting-support.r");
hpd <- read.table("all-HPD-intervals-untransformed.txt",header=TRUE)
hpd$coefficient <- hpd$contrast;

## @ 





## % pdf(file="hpd-main-figure.pdf",width=10, height=10)
## % measures <- c("gg.spr", "bb.spr","gg.eye.TFT")
## % coef.groups <- list(Matrix=c("c1","c2","c3"),
## %                      Embedded=c("c4","c5"))
## % coef.labels <- c(c1="Coef 1",c2="PP v RC",c3="Coef 3",c4="Coef 4",c5="nonlocal v local");
## % group.labels <- c(Matrix="Matrix cond",Embedded="Embedded cond")

## % plot.hpds(hpd.intervals=hpd,
## %           measures=measures,
## %           coef.groups=coef.groups,
## %           coef.labels = coef.labels,
## %           ylim=c(-50,200),
## %           measure.col=c("black","grey","grey"),
## %           non.sig.lty=c(2,2,2),
## %           non.sig.lwd=c(0.5,0.5,0.5),
## %           measure.lwd=c(2,2,2))

## % dev.off()






## <<plot-HPDs>>=

## #set up the lattice plot

pdf(file="hpd-main-figure.pdf",width=10, height=10)

par(mfrow=c(3,3))

## par(cex.sub=1.1,font.sub=3);
## par(cex.axis=1.1,cex.lab=1.1);


#create an empty plot where the original data from GG05 was in the parallel plot of RTs

plot.new()
legend(x=0,y=.5,legend=c("Grodner & Gibson (2005) materials",
                    "Short, high-frequency materials"), 
       		lty=c("solid","solid"),
		col=c("black",gray(0.5)),
		lwd= 1.5, 
		bty="n");

coef.labels <- c(c11="local v. PP", c12="local v. RC", c13="local v. PP", c14="local v. RC",
                 c3= "PP v. RC", c2="local v. nonlocal", c5="PP v. RC", c4="local v. nonlocal");

coef.groups <- list(Matrix=c("c2", "c3"),
                    Embedded=c("c4", "c5"));


group.y.positioning <- 0.22;
cex.axis <- 0.8;
cex.point <- 0.6;
cex.group.label <- 1;
x.tick <- FALSE;

## SPR plot
plot.hpds(hpd.intervals=hpd,
          measures=c("gg.spr","bb.spr"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          ylim=c(-100,250),
          title="Self-paced reading",
          measure.col=c("black",grey(0.5)))


## TFT plot

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.TFT","bb.eye.TFT"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,          
          cex.point = cex.point,          
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,          
          ylim=c(-100,250),
          ylab="",
          title="Total fixation time",
          measure.col=c("black",grey(0.5)))


## FFD plot

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.FFD","bb.eye.FFD"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.point = cex.point,          
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          ylim=c(-25,50),
          ylab="",
          title="First fixation duration",
          measure.col=c("black",grey(0.5)))

## FFD plot

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.SFD","bb.eye.SFD"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          ylim=c(-25,50),
          ylab="",
          title="Single fixation duration",
          measure.col=c("black",grey(0.5)))



## #FPRT

## plot.HPDs("gg.fprt","bb.fprt", ylim=c(-25,50))

## add.axes.and.title("First-pass reading time")		



## #RBRT

## plot.HPDs("gg.rbrt","bb.rbrt", ylim=c(-25,50))

## add.axes.and.title("Right-bounded reading time")		



## #RRT

## plot.HPDs("gg.rrt","bb.rrt",ylim=c(-50,150))

## add.axes.and.title("Re-reading time")		




## #RPD plot

## #Whether you choose ARPD or RPD here, do the same in main-RT-fig.rnw. 

## #Note that this time through, you used RPD instead of ARPD as the data base for the "RPD" model. That means it includes zeroes. You did this because it was estimating item variance at zero.

## plot.HPDs("gg.arpd","bb.arpd",ylim=c(-300,500))
## #plot.HPDs("gg.rpd","bb.rpd",ylim=c(-50,150))

## add.axes.and.title("Regression-path duration")		

dev.off()
#@
