    
dummy <- data.frame(condition = 1:6,
                    m = rep(400,6));

trim.value <- 60000;

rt.mean <- cast(d.melt, condition  ~ .,
               function(x) c(m=round(mean(x)),
                             CI=round(ci(x))),
               subset = ((value < trim.value)  & (good.subj == TRUE)));

#removed this because we want all trials: & (correct == "correct")


plot.intervals(xrange=1:6, lower=rt.mean$CI.lower,
               upper=rt.mean$CI.upper, width=0, lwd=0.5,  
               col=col,lty=linetype);

lines(x=1:3, y=rt.mean$m[1:3], lty=linetype, col=col, pch=c(20), lwd=1,type="o");
lines(x=4:6, y=rt.mean$m[4:6], lty=linetype, col=col, pch=c(20), lwd=1,type="o");
