#rm(list=ls())  # rm = remove all objects in work space

#library(xtable)
#library(weaver)
#library(lme4)



###==================================================
###  The following labels are for plotting COLOR
###==================================================

labelmag <- 2 #1.67
legendmag <- 2 #1.4
xaxismag <- 2 #
yaxismag <- 2 #1.5

###==================================================
### Standard error function definition:
###==================================================

se <- function(x)
      {
        y <- x[!is.na(x)] # remove the missing values, if any
        sqrt(var(as.vector(y))/length(y))
}

## Exact p-values in lme:

exactpnlme <- function(lmeresult){
summary(lmeresult)$tTable[,5]
}

## Create a PS file:

createPS <- function(filename){
postscript(file=filename,
           paper="a4",
           horizontal= TRUE,
           family="Times",
           pointsize=10)     
}

createPDF <- function(filename){
pdf(file = filename,
    family = "Times",
    paper="a4", pointsize=10)
}


# Create a [row x col] multiplot 

multiplot <- function(row,col){
     op <- par(mfrow=c(row,col),pty="s")
   }

# remove file from pwd
remfile.sys <- function(filename){
     if(length(system(paste("ls",filename,sep=" "), TRUE, TRUE))>0){
     system(paste("rm",filename,sep=" "), TRUE, TRUE)}
     #else{print(paste(paste("File",filename,sep=" "),"removed from cd",sep=" "))}
   }

# generic function for pretty-printing the F and p values
printFandPs <- function(aovoutput,outputfilename,subjitem){
  aovoutputnumdf <- aovoutput[,1] #numDF
  aovoutputdendf <- aovoutput[,4] #denDF
  Fs <- round(aovoutput[,5],digits=2) #f-values
  if(subjitem==1){
    Fdfs <- as.matrix(paste(paste(paste(paste(paste("F1(",aovoutputnumdf,sep=""),",",sep=""),aovoutputdendf,sep=""),c(")",")",")"),sep=""),c("=","=","="),sep=""))}
  if(subjitem==2){
    Fdfs <- as.matrix(paste(paste(paste(paste(paste("F2(",aovoutputnumdf,sep=""),",",sep=""),aovoutputdendf,sep=""),c(")",")",")"),sep=""),c("=","=","="),sep=""))}
  AllFs <- paste(Fdfs,Fs,sep="")
  Ps <- round(aovoutput[,6],digits=2) #p-values
  AllPs <- paste(rep(", p=",3),Ps,sep="")
  AllFandPs <- cbind(AllFs,AllPs)
  write(t(AllFandPs),file=outputfilename,ncolumns=2,sep="")
}


# some lattice settings to get black and white plots always

#library(lattice)
#ltheme <- canonical.theme(color=FALSE)
#ltheme$strip.background$col <- "transparent"
#lattice.options(default.theme=ltheme)

#some sensible defaults for scales:
scalelist <- list(x=list(alternating=1),
                   y=list(alternating=1),
                   tck=c(.5))

#function for plotting the regression lines:
drawfittedline <- function(x,y){
  panel.xyplot(x,y)
    	panel.lmline(x,y,type="l",lwd=1,col="white")}

#function for outputting p values in scientific notation in lme (not lmer!!!)
adjustedprint <- function(extable){
digits(extable)[c(1,2,3,4,5)] <- c(0,0,0,2,6)
display(extable)[5] <- "e"
print(extable)
}

margintext <- function(txt,sd=2,ln=2.5,mag=1.8){
 mtext(txt,side=sd,line=ln,cex=mag)
}

minf <- function(f1,f2,n1,n2){
 fprime <- (f1*f2)/(f1+f2)
 n <- round(((f1+f2)*(f1+f2))/(((f1*f1)/n2)+((f2*f2)/n1)))
# return(n)
 return(paste("minF(",n,")=",round(fprime,digits=2),#", crit=",round(qf(.95,1,n)),
              sep=""))
}


###############################################################################
# calculate p-values and mcmr confidence intervals for lmer()
###############################################################################


pvals.fnc = function(model, nsamp = 1000) {

  sink("tmp.summary.txt")
  print(model)
  sink()

  nobs = nrow(model@frame)

  raw = scan("tmp.summary.txt", sep="\n",what=character(), quiet=TRUE)
  summaryTable = FALSE
  randomSection = FALSE
  name = vector()
  coeff = vector()
  err = vector()
  tval = vector()
  random = vector()
  j = 0
  for (i in 1:length(raw)) {
    x = strsplit(raw[i], "  *") 
    if (x[[1]][1] == "Random") {
      randomSection = TRUE
      rpos = 0
    }
    if (randomSection == TRUE) {
      rpos = rpos + 1
      random[rpos] = raw[i]
      if (x[[1]][2] == "Residual") {
        residualVariance = as.numeric(x[[1]][3])
      }
    }
    if (x[[1]][1] == "Fixed") {
      summaryTable = TRUE
      randomSection = FALSE
    } 
    if (summaryTable == TRUE) {
      if (x[[1]][1] == "Correlation") {
        summaryTable = FALSE
      } else {
        if (x[[1]][1]  != "" & x[[1]][1] != "Fixed") {
          j = j + 1
          name[j] = x[[1]][1]
          coeff[j] = x[[1]][2]
          err[j] = x[[1]][3]
          tval[j] = x[[1]][4]
        }
      }
    }
  }
  ncoef = length(name)
  sumry = data.frame(Estimate=as.numeric(coeff), Std.Error = as.numeric(err), 
  DF = rep(nobs-ncoef, ncoef),
  t.value=as.numeric(tval)) 
  row.names(sumry) = name
  sumry$pvals = 2*(1-pt(abs(sumry$t.value), nobs-ncoef))
  sumry = round(sumry, 5)

  random = random[2:(length(random)-1)] 
  columnNames = unlist(strsplit(random[1], "  *"))
  columnNames = columnNames[2:length(columnNames)]
  datInfo = random[length(random)]
  groups = vector()
  name = vector()
  variance = vector()
  stdev = vector()
  correlation = vector()
  random = random[2:(length(random)-1)]

  for (i in 1:length(random)) {
    x = unlist(strsplit(random[i], "  *"))
    x = x[2:length(x)]
    if (x[2] == "(Intercept)") {
      groups[i] = x[1]
      name[i] = x[2]
      variance[i] = x[3]
      stdev[i] = x[4]
      correlation[i] = " "
    } else {
      if (x[1] == "Residual") {
        groups[i] = x[1]
        name[i] = " "
        variance[i] = x[2]
        stdev[i] = x[3]
        correlation[i] = " "
      } else {
        groups[i] = groups[i-1]
        name[i] = x[1]
        variance[i] = x[2]
        stdev[i] = x[3]
        correlation[i] = paste(x[4:length(x)], collapse=" ")
      }
    }
  }
  random = data.frame(Groups=groups, 
                      Name=name, 
                      Variance=variance, 
                      Std.Dev = stdev, 
                      Corr=correlation)
  

  sink("tmp.anova.txt")
  print(anova(model))
  sink()

  raw = scan("tmp.anova.txt", sep="\n",what=character(), quiet=TRUE)
  if (length(raw) > 2) {
    name = vector()
    Df = vector()
    SumSq = vector()
    MeanSq = vector()
    for (i in 3:length(raw)) {
      x = strsplit(raw[i], "  *")
      name[i-2] = x[[1]][1]
      Df[i-2] = x[[1]][2]
      SumSq[i-2] = x[[1]][3]
      MeanSq[i-2] = x[[1]][4]
    }
    anov = data.frame(Df = as.numeric(Df), SumSq = as.numeric(SumSq), MeanSq = 
    as.numeric(MeanSq))
    row.names(anov) = name
    anov$Denom = rep(nobs-ncoef, nrow(anov))
    anov$F = anov$MeanSq/residualVariance
    anov$pvals = 1-pf(anov$MeanSq/residualVariance, anov$Df, nobs-ncoef)
    anov = round(anov, 5)
  } else {
    anov = raw
  }

  if (nsamp == 0) 
      return(list(random = random,
              info = datInfo,
              summary = sumry,
              anova=anov,
              mcmc = NA
              ))

  samp1 = mcmcsamp(model, n=nsamp)
  require("coda", quietly = TRUE, character = TRUE)
  quantls = c(0.0005, 0.005, 0.025, 0.50, 0.975, 0.995, 0.9995)
  mcmc = round(summary(samp1, quantls)$quantiles, 5)

  if (ncoef > 1) {
    apply(mcmc[1:ncoef, 3:5] > 0,1,sum) -> ci950
    apply(mcmc[1:ncoef, 2:6] > 0,1,sum) -> ci990
    apply(mcmc[1:ncoef, 1:7] > 0,1,sum) -> ci999
  } else {
    sum(mcmc[1, 3:5] > 0) -> ci950
    sum(mcmc[1, 2:6] > 0) -> ci990
    sum(mcmc[1, 1:7] > 0) -> ci999
  }

  mcmcplus = data.frame(ci950 = (ci950==3 | ci950 == 0), 
                        ci990 = (ci990==5 | ci990 == 0),
                        ci999 = (ci999==7 | ci999 == 0))
  
  return(list(random = random,
              info = datInfo,
              summary = cbind(sumry, mcmcplus), 
              anova=anov,
              mcmc = mcmc
              ))
}


ci <- function (scores){
m <- mean(scores)
stderr <- se(scores)
len <- length(scores)
upper <- m + qt(.975, df=len-1) * stderr 
lower <- m + qt(.025, df=len-1) * stderr 
return(data.frame(lower=lower,upper=upper))
}



map <- function(vec, from, to) {
       newVec <- vec
       for( i in 1:length(from) ) {
               newVec[vec == from[i]] <- to[i]
       }
       return(newVec)
}


## Start-up comments:

.First <- function(){
    cat("\n   1. Function se loaded\n")
    cat("\n   2. xtable loaded\n\n")
    cat("See .Rprofile in home directory for details.\n\n")
  }


