#Load in the data. Be sure these files are the most recent version produced by the master .rnw files.



gg.spr<- gg.spr.data
bb.spr<-bb.spr.data
gg.eye<- gg.eye
bb.eye<-bb.eye



#Subset the SPR data for correct trials by good subjects

#gg.spr <- gg.spr[(gg.spr$correct=="correct") & (gg.spr$good.subj==TRUE),];
#bb.spr <- bb.spr[(bb.spr$correct=="correct") & (bb.spr$good.subj==TRUE),];


gg.spr <- gg.spr[(gg.spr$good.subj==TRUE),];
bb.spr <- bb.spr[(bb.spr$good.subj==TRUE),];



#make a file for storing HPDs

hpd.columns<-c("contrast","M","ci.lower","ci.upper","measure")
write.table(t(hpd.columns),file="all-HPD-intervals.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)

#another table for length and frequency HPDs
cov.columns<-c("covariate","ci.lower","ci.upper","measure")
write.table(t(cov.columns),file="length-frequency-hpds.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)

#Define the print function that will feed file created above.


#must do first for each analysis
#m <- mcmcsamp(lmermodel, 50000) 

printHPDs <- function(m,measure=NA){
  intervals<-(HPDinterval(m)$fixef)
  M <- rowMeans(intervals[2:6,] )  
  HPDs <- data.frame(M=M,
                     ci.lower=intervals[2:6,1],
                     ci.upper=intervals[2:6,2],
                     measure<-measure)
                     
  as.data.frame(HPDs);
  write.table(HPDs,file="all-HPD-intervals.txt",append=TRUE,quote=FALSE,sep="\t",col.names=FALSE)                
  }
  
 #this function outputs HPD intervals for length and frequency
  
covarHPDs<- function(m,measure){
	intervals<-(HPDinterval(m)$fixef)
	HPDs<-data.frame(ci.lower=intervals[7:8,1],
					ci.upper=intervals[7:8,2],
					measure<-measure)
					
	as.data.frame(HPDs)
	write.table(HPDs,file="length-frequency-hpds.txt",append=TRUE,quote=FALSE,sep="\t",col.names=FALSE)
}
	
#Run the analyses and plot the resulting HPD intervals.




##### GG - SPR


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subj) + (1|item),
                          data=gg.spr,
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, msVerbose=F, EMverbose=F ) ) );


m <- mcmcsamp(lmermodel, 50000) 

printHPDs(m,"gg.spr")
covarHPDs(m,"gg.spr")


summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subj) + (1|item),
                         data=gg.spr,
                         control=list(gradient=FALSE, niterEM=0, maxIter=200, msVerbose=F, EMverbose=F ) ));

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.spr")
covarHPDs(m,"gg.spr")




######BB - SPR 

summary(lmermodel  <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subj) + (1|item) ,
                          data=bb.spr,
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, msVerbose=F, EMverbose=F ) ));

m <- mcmcsamp(lmermodel, 50000) 

printHPDs(m,"bb.spr")
covarHPDs(m,"bb.spr")





summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subj) + (1|item) ,
                         data=bb.spr,
                         control=list(gradient=FALSE, niterEM=0, maxIter=200, msVerbose=F, EMverbose=F )) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.spr")
covarHPDs(m,"bb.spr")




###################GG - EYE

#SFD


sfddata<- subset(gg.eye,times=="SFD" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + log(prev.LPRT) 
                                + (1|subject) + (1|item)  ,  
                          data=sfddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.sfd")
covarHPDs(m,"gg.sfd")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + log(prev.LPRT) 
                                + (1|subject) + (1|item)  ,  
                          data=sfddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.sfd")
covarHPDs(m,"gg.sfd")


#FFD



ffddata<- subset(gg.eye,times=="FFD" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + log(prev.LPRT) 
                                + (1|subject) + (1|item)  ,  
                          data=ffddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.ffd")
covarHPDs(m,"gg.ffd")



summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + log(prev.LPRT) 
                                + (1|subject) + (1|item)  ,  
                          data=ffddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.ffd")
covarHPDs(m,"gg.ffd")



#gg-FPRT1


fprtdata<- subset(gg.eye,times=="FPRT" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + log(prev.LPRT) 
                                + (1|subject) + (1|item)  ,  
                          data=fprtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)))

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.fprt")
covarHPDs(m,"gg.fprt")



summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + log(prev.LPRT) 
                                + (1|subject) + (1|item)  ,  
                          data=fprtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) )

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.fprt")
covarHPDs(m,"gg.ffd")

#RBRT


rbrtdata<- subset(gg.eye,times=="RBRT" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=rbrtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)))

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.rbrt")
covarHPDs(m,"gg.rbrt")


summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                          data=rbrtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.rbrt")
covarHPDs(m,"gg.rbrt")


#RPD


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=gg.eye,subset=times=="RPD", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.rpd")
covarHPDs(m,"gg.rpd")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=gg.eye,subset=times=="RPD", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.rpd")
covarHPDs(m,"gg.rpd")



#ARPD


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=gg.eye,subset=times=="ARPD", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.arpd")
covarHPDs(m,"gg.arpd")


summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=gg.eye,subset=times=="ARPD", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.arpd")
covarHPDs(m,"gg.arpd")

#RRT

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=gg.eye,subset=times=="RRT", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.rrt")
covarHPDs(m,"gg.rrt")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=gg.eye,subset=times=="RRT", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.rrt")
covarHPDs(m,"gg.rrt")

#LPRT


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=gg.eye,subset=times=="LPRT", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.lprt")
covarHPDs(m,"gg.lprt")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=gg.eye,subset=times=="LPRT", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.lprt")
covarHPDs(m,"gg.lprt")


#TFT

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=gg.eye,subset=times=="TFT", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.tft")
covarHPDs(m,"gg.tft")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=gg.eye,subset=times=="TFT", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"gg.tft")
covarHPDs(m,"gg.tft")

###################bb - EYE

#SFD

sfddata<- subset(bb.eye,times=="SFD" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + log(prev.LPRT)  
                                + (1|subject) + (1|item),  
                          data=sfddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.sfd")
covarHPDs(m,"bb.sfd")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + log(prev.LPRT)   
                                + (1|subject) + (1|item),  
                          data=sfddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.sfd")
covarHPDs(m,"bb.sfd")

#bb-FFD


ffddata<- subset(bb.eye,times=="FFD" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen   + log(prev.LPRT) 
                                + (1|subject) + (1|item),  
                          data=ffddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)))

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.ffd")
covarHPDs(m,"bb.ffd")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen   + log(prev.LPRT) 
                                + (1|subject) + (1|item),  
                          data=ffddata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.ffd")
covarHPDs(m,"bb.ffd")


#bb-FPRT


fprtdata<- subset(bb.eye,times=="FPRT" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen   + log(prev.LPRT) 
                                + (1|subject) + (1|item),  
                          data=fprtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)))

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.fprt")
covarHPDs(m,"bb.fprt")


summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen   + log(prev.LPRT) 
                                + (1|subject) + (1|item),  
                          data=fprtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)));

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.fprt")
covarHPDs(m,"bb.fprt")


#bb-RBRT

rbrtdata<- subset(bb.eye,times=="RBRT" & prev.LPRT > 0);

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=rbrtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)))

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.rbrt")
covarHPDs(m,"bb.rbrt")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                          data=rbrtdata,
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.rbrt")
covarHPDs(m,"bb.rbrt")

#bb-RPD

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=bb.eye,subset=times=="RPD", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.rpd")
covarHPDs(m,"bb.rpd")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=bb.eye,subset=times=="RPD", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.rpd")
covarHPDs(m,"bb.rpd")


#bb-ARPD

summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=bb.eye,subset=times=="ARPD", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.arpd")
covarHPDs(m,"bb.arpd")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=bb.eye,subset=times=="ARPD", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.arpd")
covarHPDs(m,"bb.arpd")

#bb-RRT


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=bb.eye,subset=times=="RRT", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.rrt")
covarHPDs(m,"bb.rrt")

summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=bb.eye,subset=times=="RRT", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.rrt")
covarHPDs(m,"bb.rrt")



#bb-LPRT


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=bb.eye,subset=times=="LPRT", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.lprt")
covarHPDs(m,"bb.lprt")


summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=bb.eye,subset=times=="LPRT", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.lprt")
covarHPDs(m,"bb.lprt")


#bb-TFT


summary(lmermodel <- lmer(log(value) ~ c1 + c2 + c3 + c4 + c5 + cfreq + clen + (1|subject) + (1|item),  
                          data=bb.eye,subset=times=="TFT", 
                          control=list(gradient=FALSE, niterEM=0, maxIter=200, 
                            msVerbose=F, EMverbose=F )) );
                            
m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.tft")
covarHPDs(m,"bb.tft")


summary(lmermodel <- lmer(log(value) ~ c6 + c7 + c8 + c9 + c10 + cfreq + clen + (1|subject) + (1|item),  
                         data=bb.eye,subset=times=="TFT", 
                          control=list(gradient=FALSE, 
                            niterEM=0, maxIter=200, msVerbose=F, EMverbose=F)) );

m<- mcmcsamp(lmermodel,50000)

printHPDs(m,"bb.tft")
covarHPDs(m,"bb.tft")

