#\section{HPD plots}

#Now we set up the plots.


#<plot-HPD-untransformed-intervals-setup>>=
## read HPD interval tables and support code
source("hpd-plotting-support.r");
#@ 



#<<setup-HPDs-plots>>=
hpd <- read.table("all-HPD-intervals-untransformed.txt",header=TRUE)

pdf(file="hpd-locality-untransformed.pdf",width=10, height=10)

par(mfrow=c(3,3))

## par(cex.sub=1.1,font.sub=3);
## par(cex.axis=1.1,cex.lab=1.1);


#create an empty plot where the original data from GG05 was in the parallel plot of RTs

coef.labels <- c(c11="local vs. PP", c12="local vs. RC",
                 c13="local vs. PP", c14="local vs. RC", 
                 c3= "PP vs. RC", c2="local vs.\n nonlocal",
                 c5="PP vs. RC", c4="local vs.\n nonlocal");  

coef.groups <- list(Matrix=c("c2", "c3"),
                    Embedded=c("c4", "c5"));
group.labels <- NULL

group.y.positioning <- 0.25;   #-0.02;
cex.axis <- 1.0;
cex.main <- 1.6;
cex.point <- 0.8;
cex.group.label <- 1.2;
x.tick <- FALSE;

spr.tft.lim <- c(-100,300);
late.measure.lim <- c(-300,800);
early.measure.lim <- c(-25,100);

## @ 


#<<plot-hpds>>=

plothpds <- function() {
plot.new()
legend(x=0,y=.5,legend=c("Grodner & Gibson (2005) materials",
                    "Short, high-frequency materials"), 
       		lty=c("solid","solid"),
		col=c("black",gray(0.5)),
		lwd= 1.5, 
		bty="n");


## SPR plot
plot.hpds(hpd.intervals=hpd,
          measures=c("gg.spr","bb.spr"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          cex.main=cex.main,
          x.tick=x.tick,
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,
          ylim=spr.tft.lim,
          ylab="Coefficient estimate (ms)",
          title="Self-paced Reading",
          measure.col=c("black",grey(0.4)))


## TFT plot

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.TFT","bb.eye.TFT"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          cex.main=cex.main,          
          x.tick=x.tick,          
          cex.point = cex.point,          
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,          
          ylim=spr.tft.lim,
          ylab="",
          title="Total Fixation Time",
          measure.col=c("black",grey(0.4)))


## FFD plot

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.FFD","bb.eye.FFD"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.main=cex.main,
          cex.point = cex.point,          
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,
          ylim=early.measure.lim,
          ylab="Coefficient estimate (ms)",
          title="First Fixation Duration",
          measure.col=c("black",grey(0.4)))

## SFD plot

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.SFD","bb.eye.SFD"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.main=cex.main,          
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,          
          ylim=early.measure.lim,
          ylab="",
          title="Single Fixation Duration",
          measure.col=c("black",grey(0.4)))


## FPRT

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.FPRT","bb.eye.FPRT"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.main=cex.main,          
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,          
          ylim=early.measure.lim,
          ylab="",
          title="First-pass Reading Time",
          measure.col=c("black",grey(0.4)))


## RRT

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.RRT","bb.eye.RRT"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.main=cex.main,          
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,          
          ylim=late.measure.lim,
          ylab="Coefficient estimate (ms)",
          title="Re-reading Time",
          measure.col=c("black",grey(0.4)))



## RPD

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.RPD","bb.eye.RPD"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.main=cex.main,          
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,          
          ylim=late.measure.lim,
          ylab="",
          title="Regression Path Duration",
          measure.col=c("black",grey(0.4)))



## ARPD

plot.hpds(hpd.intervals=hpd,
          measures=c("gg.eye.ARPD","bb.eye.ARPD"),
          coef.groups=coef.groups,
          coef.labels=coef.labels,
          cex.axis=cex.axis,
          x.tick=x.tick,
          cex.main=cex.main,          
          cex.point = cex.point,
          cex.group.label=cex.group.label,
          group.y.positioning=group.y.positioning,
          group.labels=group.labels,          
          ylim=late.measure.lim,
          ylab="",
          title="Nonzero Regression Path Duration",
          measure.col=c("black",grey(0.4)))

dev.off();
}

plothpds();

hpd <- read.table("all-HPD-intervals-log-transformed.txt",header=TRUE)

pdf(file="hpd-locality-log-transformed.pdf",width=10, height=10)
par(mfrow=c(3,3))

spr.tft.lim <- c(-0.2,0.4);
early.measure.lim <- c(-0.1,0.4);
late.measure.lim <- c(-0.5,1.0);

plothpds()


hpd <- read.table("all-HPD-intervals-untransformed.txt",header=TRUE)

pdf(file="hpd-embedding-untransformed.pdf",width=10, height=10)

par(mfrow=c(3,3))

coef.labels <- c(c1="Embedding",
                 c6="Embedding\n X Locality",
                 c7="Embedding\n X Modification");

coef.groups <- list(g1=c("c1"),
                    g2=c("c6", "c7"));
group.labels = c(g1="Main effect",
                 g2="Interactions")

spr.tft.lim <- c(-100,350);
late.measure.lim <- c(-300,600);
early.measure.lim <- c(-25,80);


plothpds()



hpd <- read.table("all-HPD-intervals-log-transformed.txt",header=TRUE)

pdf(file="hpd-embedding-log-transformed.pdf",width=10, height=10)
par(mfrow=c(3,3))

spr.tft.lim <- c(-0.2,0.5);
early.measure.lim <- c(-0.1,0.5);
late.measure.lim <- c(-0.2,1.0);

plothpds()

## #RBRT

## plot.HPDs("gg.rbrt","bb.rbrt", ylim=c(-25,50))

## add.axes.and.title("Right-bounded reading time")		



## #RRT

## plot.HPDs("gg.rrt","bb.rrt",ylim=c(-50,150))

## add.axes.and.title("Re-reading time")		




## #RPD plot

## #Whether you choose ARPD or RPD here, do the same in main-RT-fig.rnw. 

## #Note that this time through, you used RPD instead of ARPD as the data base for the "RPD" model. That means it includes zeroes. You did this because it was estimating item variance at zero.

## plot.HPDs("gg.arpd","bb.arpd",ylim=c(-300,500))
## #plot.HPDs("gg.rpd","bb.rpd",ylim=c(-50,150))

## add.axes.and.title("Regression-path duration")		
#@ 



