## ----setup,include=TRUE,warning=FALSE, message=FALSE, cache=FALSE, echo=FALSE----
library(knitr)
library(coda)

# set global chunk options, put figures into folder
options(replace.assign=TRUE,show.signif.stars=FALSE)
opts_chunk$set(fig.path='figures/figure-', fig.align='center', fig.show='hold')
# options(replace.assign=TRUE,width=75)
# opts_chunk$set(dev='postscript')
#library(rstan)
#set.seed(9991)
# save workspace image, if you want
#the.date <- format(Sys.time(), "%b%d%Y")
#save.image(file=paste0("homework01-",the.date,".RData")

## ------------------------------------------------------------------------
n<-100
beta1<-6
beta2<- -0.07
sigma <- 0.5
x<-rep(c(-0.5,0.5),each=n/2)
y <- beta1+ beta2*x + rnorm(n,mean=0,sd=sigma)

## ----solutionfakedatalm,echo=TRUE, include=TRUE--------------------------
nsim<-1000
beta<-matrix(rep(NA,nsim*2),ncol=2)
s<-rep(NA,nsim)
for(i in 1:nsim){
  ## generate data
  y <- beta1+ beta2*x + rnorm(n,mean=0,sd=sigma) 
  ## fit linear model
  mfake<-lm(y~x)
  ## extract parameters and store in a vector
  beta[i,]<-coef(mfake)
  s[i]<-summary(mfake)$sigma
}

## ----solutionfakedatalmsuite,echo=TRUE, include=TRUE, out.width='3in', small.mar=TRUE----
op<-par(mfrow=c(1,3),pty="s", mar = c(30, 3, 3, 3))
hist(beta[,1])
abline(v=beta1)
hist(beta[,2])
abline(v=beta2)
hist(s)
abline(v=sigma)

