## ----setup,include=FALSE,cache=FALSE, echo=FALSE-------------------------
library(knitr)
library(coda)
library(lattice)
# set global chunk options, put figures into folder
options(replace.assign=TRUE,show.signif.stars=FALSE)
opts_chunk$set(fig.path='figures/figure-', fig.align='center', fig.show='hold')
# options(replace.assign=TRUE,width=75)
# opts_chunk$set(dev='postscript')
#library(rstan)
#set.seed(9991)
# save workspace image, if you want
#the.date <- format(Sys.time(), "%b%d%Y")
#save.image(file=paste0("homework01-",the.date,".RData")

## ------------------------------------------------------------------------
noisedeg<-read.table("data/noisedeg.txt",
                     header=TRUE)
means.noise<-with(noisedeg,tapply(rt,list(subj,noise),
                                  mean))
means.deg<-with(noisedeg,tapply(rt,list(subj,
                                        deg),mean))

## ------------------------------------------------------------------------
head(means.noise, n=3)
head(means.deg, n=3)

## ----echo=TRUE, tidy=FALSE, Warning=FALSE, message=FALSE, out.width='1.8in'----
# library(lattice)
print(xyplot(rt~noise|subj, panel=function(x,y,...)            
          {panel.xyplot(x,y,type="r")},noisedeg))

## ----echo=TRUE,tidy=FALSE, out.width='2in'-------------------------------
print(xyplot(rt~deg|subj,
        panel=function(x,y,...)
          {panel.xyplot(x,y,type="r")},noisedeg))

## ------------------------------------------------------------------------
## fit a separate linear model for subject s1:
s1data<-subset(noisedeg,subj=="s1")
m<-lm(rt~noise,s1data)
round(summary(m)$coefficients,digits=2)

## ----warning=FALSE, message=FALSE----------------------------------------
## do the same as the above for-loop for each subject:
library(lme4)

lmlist.fm1<-lmList(rt~noise|subj,noisedeg)

## ------------------------------------------------------------------------
lmlist.fm1$s1$coefficients

## ----echo=FALSE,out.width='2in'------------------------------------------
plot(as.numeric(noisedeg$noise)-1,
     noisedeg$rt,axes=F,
     xlab="noise",ylab="rt")
axis(1,at=c(0,1),
     labels=c("no.noise","noise"))
axis(2)

subjects<-paste("s",1:10,sep="")

for(i in subjects){
abline(lmlist.fm1[[i]])
}

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

## ------------------------------------------------------------------------
t.test(coef(lmlist.fm1)[2])

## ------------------------------------------------------------------------
m0.lmer<-lmer(rt~noise+(1|subj),noisedeg)

## ------------------------------------------------------------------------
ranef(m0.lmer)

## ----out.width='2in'-----------------------------------------------------
print(dotplot(ranef(m0.lmer,condVar=TRUE)))

## ----echo=FALSE,out.width='2in'------------------------------------------
a<-fixef(m0.lmer)[1]
newa<-a+ranef(m0.lmer)$subj

ab<-data.frame(newa=newa,b=fixef(m0.lmer)[2])

plot(as.numeric(noisedeg$noise)-1,noisedeg$rt,xlab="noise",ylab="rt",axes=F)
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

for(i in 1:10){
abline(a=ab[i,1],b=ab[i,2])
}

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

## ------------------------------------------------------------------------
m1.lmer<-lmer(rt~noise+(1+noise|subj),noisedeg)

## ----echo=FALSE,out.width='2in'------------------------------------------
a<-fixef(m1.lmer)[1]
b<-fixef(m1.lmer)[2]

newa<-a+ranef(m1.lmer)$subj[1]
newb<-b+ranef(m1.lmer)$subj[2]

ab<-data.frame(newa=newa,b=newb)

plot(as.numeric(noisedeg$noise)-1,noisedeg$rt,xlab="noise",ylab="rt",axes=F,
main="varying intercepts and slopes for each subject")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

for(i in 1:10){
abline(a=ab[i,1],b=ab[i,2])
}

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

## ----echo=FALSE,out.width='3in'------------------------------------------
op<-par(mfrow=c(1,2),pty="s")

plot(as.numeric(noisedeg$noise)-1,noisedeg$rt,axes=F,xlab="noise",ylab="rt",main="ordinary linear model")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

subjects<-paste("s",1:10,sep="")

for(i in subjects){
abline(lmlist.fm1[[i]])
}

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

a<-fixef(m1.lmer)[1]
b<-fixef(m1.lmer)[2]

newa<-a+ranef(m1.lmer)$subj[1]
newb<-b+ranef(m1.lmer)$subj[2]

ab<-data.frame(newa=newa,b=newb)

plot(as.numeric(noisedeg$noise)-1,noisedeg$rt,axes=F,
main="varying intercepts and slopes",xlab="noise",ylab="rt")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

for(i in 1:10){
abline(a=ab[i,1],b=ab[i,2])
}

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

## ----echo=FALSE----------------------------------------------------------
noisedeg2<-read.table("data/noisedegfull.txt",header=T)

## ----echo=FALSE----------------------------------------------------------
with(noisedeg2,tapply(rt,list(subj,noise),
                      mean,na.rm=TRUE))

## ----echo =FALSE---------------------------------------------------------
lmlist.fm2<-lmList(rt~noise|subj,noisedeg2)

m2.lmer<-lmer(rt~noise+(1+noise|subj),noisedeg2)

## ----echo=FALSE,fig.height=4---------------------------------------------
op<-par(mfrow=c(1,2),pty="s")

## reduced data:
plot(as.numeric(noisedeg2$noise)-1,noisedeg2$rt,axes=F,xlab="noise",ylab="rt",main="ordinary linear model",sub="s8, missing data")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

abline(lmlist.fm2$s8)

abline(lm(rt~noise,noisedeg2),lwd=3,col="red")

a<-fixef(m2.lmer)[1]
b<-fixef(m2.lmer)[2]

newa<-a+ranef(m2.lmer)$subj[1]
newb<-b+ranef(m2.lmer)$subj[2]

ab<-data.frame(newa=newa,b=newb)

plot(as.numeric(noisedeg2$noise)-1,noisedeg2$rt,axes=F,
main="varying intercepts and slopes",
sub="s8, missing data",
xlab="noise",ylab="rt")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)


abline(a=ab[9,1],b=ab[9,2])

abline(lm(rt~noise,noisedeg2),lwd=3,col="red")

## ----echo=FALSE,fig.height=4---------------------------------------------
## unreduced
op<-par(mfrow=c(1,2),pty="s")

plot(as.numeric(noisedeg$noise)-1,noisedeg$rt,axes=F,xlab="noise",ylab="rt",main="ordinary linear model",
,sub="s8, no missing data")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

abline(lmlist.fm1$s8)

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

a<-fixef(m2.lmer)[1]
b<-fixef(m2.lmer)[2]

newa<-a+ranef(m1.lmer)$subj[1]
newb<-b+ranef(m1.lmer)$subj[2]

ab<-data.frame(newa=newa,b=newb)

plot(as.numeric(noisedeg$noise)-1,noisedeg$rt,axes=F,
main="varying intercepts and slopes",sub="s8, no missing data",xlab="noise",ylab="rt")
axis(1,at=c(0,1),labels=c("no.noise","noise"))
axis(2)

abline(a=ab[9,1],b=ab[9,2])

abline(lm(rt~noise,noisedeg),lwd=3,col="red")

