## ----setup,include=TRUE,warning=FALSE, message=FALSE, cache=FALSE, echo=FALSE----
library(knitr)
library(coda)

# set global chunk options, put figures into folder
options(replace.assign=TRUE,show.signif.stars=FALSE)
opts_chunk$set(fig.path='figures/figure-', fig.align='center', fig.show='hold')
# options(replace.assign=TRUE,width=75)
# opts_chunk$set(dev='postscript')
#library(rstan)
#set.seed(9991)
# save workspace image, if you want
#the.date <- format(Sys.time(), "%b%d%Y")
#save.image(file=paste0("homework01-",the.date,".RData")

## ----echo=TRUE-----------------------------------------------------------
stress_sympt<-read.table("data/StressSymptomes.txt",
                         header=TRUE)
head(stress_sympt, n=5)

## ------------------------------------------------------------------------
plot(stress_sympt$symptomes~stress_sympt$stress)

## ----echo=TRUE-----------------------------------------------------------
m=lm(symptomes~stress, data=stress_sympt) 

## ------------------------------------------------------------------------
## residuals:
res.m<-residuals(m)

## ----echo=TRUE-----------------------------------------------------------
library(car)
qqPlot(res.m)

## ----echo=TRUE, hide=FALSE, include= TRUE--------------------------------
coef(m)

## ----echo=TRUE, out.width='2in'------------------------------------------
plot(stress_sympt$symptomes~stress_sympt$stress)
abline(m)

## ------------------------------------------------------------------------
head(model.matrix(m),n=7)

## ------------------------------------------------------------------------
noisedeg<-read.table("data/noisedeg.txt",header=TRUE)
head(noisedeg)

## ------------------------------------------------------------------------
means<-with(noisedeg,tapply(rt,IND=list(noise,deg),
                            mean))
means

## ------------------------------------------------------------------------
no.noise<-subset(noisedeg,noise=="no.noise")
no.noise.means<-with(no.noise,tapply(rt,subj,mean))

noise<-subset(noisedeg,noise=="noise")
noise.means<-with(noise,tapply(rt,subj,mean))

## ------------------------------------------------------------------------
no.noise.means
noise.means

## ------------------------------------------------------------------------
## means of noise levels:
with(noisedeg,tapply(rt,noise,mean))
## mean of no.noise=486
## mean of noise=486+90=576

## ------------------------------------------------------------------------
t.test(noise.means,no.noise.means,paired=TRUE)

## ------------------------------------------------------------------------
t.test(noise.means,no.noise.means,
       paired=TRUE)$statistic
t.test(no.noise.means,noise.means,
       paired=TRUE)$statistic

## ------------------------------------------------------------------------
noisedeg$noise_R<-ifelse(noisedeg$noise=="no.noise",0,1)
head(noisedeg)

## ------------------------------------------------------------------------
m0<-lm(rt~noise_R,noisedeg)
round(summary(m0)$coefficients,digits=2)

## ------------------------------------------------------------------------
coef(m0)

## ------------------------------------------------------------------------
## means of noise levels:
with(noisedeg,tapply(rt,noise,mean))
## mean of no.noise=486
## mean of noise=486+90=576

## ------------------------------------------------------------------------
n<-10
beta1<-486
beta2<- 90
sigma <-105
x<-rep(c(0,1),each=n/2)
y <- beta1+ beta2*x + rnorm(n,mean=0,sd=sigma)

## ------------------------------------------------------------------------
print(m<-lm(y~x))

