## ----include=FALSE-------------------------------------------------------
library(knitr)
# set global chunk options, put figures into folder
options(replace.assign=TRUE,show.signif.stars=FALSE)
opts_chunk$set(fig.path='exfigures/exfigure-', fig.align='center', fig.show='hold')
options(replace.assign=TRUE,width=75)
opts_chunk$set(dev='postscript')
options(show.signif.stars=FALSE)
knitr::opts_chunk$set(tidy = T,cache=T, autodep=TRUE)
library(lme4)

## ------------------------------------------------------------------------
rbinom(n=1,size=1,prob=0.5)

## ------------------------------------------------------------------------
rbinom(n=10,size=1,prob=0.5)

## ------------------------------------------------------------------------
mean(rbinom(n=10,size=1,prob=0.5))

## ------------------------------------------------------------------------
nsim<-1000
mn<-rep(NA,nsim)
for(i in 1:nsim){
  mn[i]<-mean(rnorm(n=100,mean=500,sd=50))
}

## ----fig.height=3--------------------------------------------------------
hist(mn)

## ----echo=FALSE,include=FALSE--------------------------------------------
mean(mn)

## ----echo=FALSE,include=FALSE--------------------------------------------
#True value: 50/sqrt(10)
sd(mn)

## ------------------------------------------------------------------------
samp<-rexp(n=100)

## ----echo=FALSE,include=FALSE--------------------------------------------
nsim<-1000
mn<-rep(NA,nsim)
for(i in 1:nsim){
  mn[i]<-mean(rexp(n=100))
}
hist(mn)
sd(mn)

## ------------------------------------------------------------------------
samp<-runif(n=100,min=0,max=1)

## ----echo=FALSE,include=FALSE--------------------------------------------
nsim<-1000
mn<-rep(NA,nsim)
for(i in 1:nsim){
  mn[i]<-mean(runif(n=100,min=0,max=1))
}
hist(mn)
sd(mn)

## ------------------------------------------------------------------------
samp<-rpois(100,lambda=2)

## ----poissonclt,echo=FALSE,include=FALSE---------------------------------
mn<-rep(NA,1000)
for(i in 1:1000){
  x<-rpois(100,lambda=2)
  mn[i]<-mean(x)
}
hist(mn)

## ------------------------------------------------------------------------
x<-rcauchy(1000)
hist(x)
summary(x)

## ----echo=FALSE,include=FALSE--------------------------------------------
mn<-rep(NA,1000)
for(i in 1:1000){
x<-rcauchy(1000)
mn[i]<-mean(x)
}
hist(mn)

## ------------------------------------------------------------------------
dataN2<-read.table("data/dataN2.txt",header=T)
head(dataN2)

## ------------------------------------------------------------------------
## significant effect:
with(dataN2,
t.test(N2_dur.2,N2_dur.1,paired=TRUE))

## ----tidy=FALSE----------------------------------------------------------
N2dur1data<-data.frame(item=dataN2$Sentence,
                          subj=dataN2$Speaker_id,
                          cond="a",
                          dur=dataN2$N2_dur.1)
N2dur2data<-data.frame(item=dataN2$Sentence,
                          subj=dataN2$Speaker_id,
                          cond="b",
                          dur=dataN2$N2_dur.2)

N2data<-rbind(N2dur1data,N2dur2data)

## ------------------------------------------------------------------------
head(N2data)

## ------------------------------------------------------------------------
N2data_bysubj<-aggregate(dur~subj+cond,mean,
               data=N2data)

## ------------------------------------------------------------------------
conda<-subset(N2data_bysubj,cond=="a")
condb<-subset(N2data_bysubj,cond=="b")

## ------------------------------------------------------------------------
## not significant:
t.test(condb$dur,conda$dur,paired=TRUE)

## ------------------------------------------------------------------------
## alternative syntax:
t.test(dur~cond,paired=TRUE,N2data_bysubj)

## ------------------------------------------------------------------------
## STEP 1: Aggregate over items:
#N2data_byitem<-aggregate(dur~item+cond,mean,
#               data=N2data)

## ------------------------------------------------------------------------
## STEP 2: Create a vector for condition a and b:
#conda<-subset(N2data_byitem,cond=="a")
#condb<-subset(N2data_byitem,cond=="b")
#conda<-...
#condb<-...
## Do a by items paired t-test:
#t.test(condb$dur,conda$dur,paired=TRUE)

## ------------------------------------------------------------------------
y<-rnorm(100,mean=0,sd=0.5)

## ------------------------------------------------------------------------
nsim<-1000
pvals<-rep(NA,nsim)
for(i in 1:nsim){
  y<-rnorm(100,mean=0,sd=10)
  pvals[i]<-t.test(y)$p.value
}
## approximately 5%
mean(pvals<0.05)

## ------------------------------------------------------------------------
noisedeg<-read.table("data/noisedeg.txt",header=TRUE)

noisedeg$deg_R<-ifelse(noisedeg$deg=="0",0,1)
noisedeg$noise_R<-ifelse(noisedeg$noise=="no.noise",0,1)
head(noisedeg)

## ----echo=TRUE-----------------------------------------------------------
m1<-lm(rt~deg_R+noise_R, data=noisedeg)

## ----echo=TRUE-----------------------------------------------------------
## residuals:
res.m1<-residuals(m1)
library(car)
qqPlot(res.m1)

## ----echo=TRUE-----------------------------------------------------------
round(summary(m1)$coefficients,3)

## ------------------------------------------------------------------------
m2<-lm(rt~deg_R*noise_R, data=noisedeg)

## ------------------------------------------------------------------------
n<-100
beta1<-6
beta2<- -0.07
sigma <-0.5
x<-rep(c(-0.5,0.5),each=n/2)
  
y <- beta1+ beta2*x + rnorm(n,mean=0,sd=sigma) 

## ------------------------------------------------------------------------
summary(m<-lm(y~x))

## ------------------------------------------------------------------------
coef(m)
summary(m)$sigma

## ----solutionfakedatalm,echo=FALSE,fig.width=9---------------------------
nsim<-1000
beta<-matrix(rep(NA,nsim*2),ncol=2)
s<-rep(NA,nsim)
for(i in 1:nsim){
  ## generate data
  y <- beta1+ beta2*x + rnorm(n,mean=0,sd=sigma) 
  ## fit linear model
  mfake<-lm(y~x)
  ## extract parameters and store in a vector
  beta[i,]<-coef(mfake)
  s[i]<-summary(mfake)$sigma
}
op<-par(mfrow=c(1,3),pty="s")
hist(beta[,1],xlim=c(5.5,7.5))
abline(v=beta1)
hist(beta[,2])
abline(v=beta2)
hist(s)
abline(v=sigma)

## ----tidy=FALSE----------------------------------------------------------
nsim<-1000
for(i in 1:nsim){
  ## generate data
  ## fit linear model
  ## extract parameters and store in a vector
}

## ------------------------------------------------------------------------
var1<-100
var2<-200
rho<- 0.9

## ----tidy=FALSE----------------------------------------------------------
library(MASS)

Sigma <- matrix(c(var1,
                  sqrt(var1)*sqrt(var2)*rho,
                  sqrt(var1)*sqrt(var2)*rho,
                  var2),ncol=2)

Sigma

u<-mvrnorm(n=100,
             mu=c(0,0),Sigma=Sigma)
head(u)

## ------------------------------------------------------------------------
plot(u[,1],u[,2])

## ------------------------------------------------------------------------
## by subject intercepts:
bi<-rnorm(100,sd=.3)
## random error:
epsilon1<-rnorm(100,mean=0,sd=0.4)
epsilon2<-rnorm(100,mean=0,sd=0.4)
# observed data:
y1<-6-0.07*.5 + bi + epsilon1
y2<-6+0.07*.5 + bi + epsilon2
t.test(y2,y1,paired=TRUE)

## ------------------------------------------------------------------------
dat<-data.frame(subj=rep(1:100,2),
                y=c(y1,y2),x=rep(c(-0.5,0.5),
                                 each=100))
head(dat)
m<-lmer(y~x+(1|subj),dat)
summary(m)

## ------------------------------------------------------------------------
source("R/gen_fake_lnorm.R")

## ----cache=TRUE,tidy=FALSE-----------------------------------------------
nsim<-100
tval<-rep(NA,nsim)
for(i in 1:nsim){
dat<-gen_fake_lnorm(nsubj=20,nitem=16,
                    beta=c(6,-0.07),
                         ranefsd=c(0.25,0.12,
                                   0.18,0.0004),
                         corr=c(-.6,-.6),
                         sigma_e=0.51)  
mfake<-lmer(log(rt)~x+(1+x|subj)+(1+x|item),dat)
tval[i]<-summary(mfake)$coefficients[2,3]
}
## power:
mean(abs(tval)>2)

